package com.ejie.ab18a.service;

import com.ejie.ab18a.dao.Ab18aTipoValidacionDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aTipoValidacion;

/**
 * Ab18aTipoValidacionServiceImpl generated by XXXX, 03-feb-2017 12:08:05.
 * 
 * @author XXXX
 */

@Service(value = "ab18a10s00Service")
public class Ab18aTipoValidacionServiceImpl implements
		Ab18aTipoValidacionService {

	@Autowired
	private Ab18aTipoValidacionDao tipoValidacionDao;

	/**
	 * Inserts a single row in the Ab18a10s00 table.
	 * 
	 * @param tipoValidacion
	 *            Ab18a10s00
	 * @return Ab18a10s00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aTipoValidacion add(Ab18aTipoValidacion tipoValidacion) {
		return this.tipoValidacionDao.add(tipoValidacion);
	}

	/**
	 * Updates a single row in the Ab18a10s00 table.
	 * 
	 * @param tipoValidacion
	 *            Ab18a10s00
	 * @return Ab18a10s00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aTipoValidacion update(Ab18aTipoValidacion tipoValidacion) {
		return this.tipoValidacionDao.update(tipoValidacion);
	}

	/**
	 * Finds a single row in the Ab18a10s00 table.
	 * 
	 * @param tipoValidacion
	 *            Ab18a10s00
	 * @return Ab18a10s00
	 */
	public Ab18aTipoValidacion find(Ab18aTipoValidacion tipoValidacion) {
		return (Ab18aTipoValidacion) this.tipoValidacionDao
				.find(tipoValidacion);
	}

	/**
	 * Deletes a single row in the Ab18a10s00 table.
	 * 
	 * @param tipoValidacion
	 *            Ab18a10s00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Ab18aTipoValidacion tipoValidacion) {
		this.tipoValidacionDao.remove(tipoValidacion);
	}

	/**
	 * Finds a list of rows in the Ab18a10s00 table.
	 * 
	 * @param tipoValidacion
	 *            Ab18a10s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a10s00>
	 */
	public List<Ab18aTipoValidacion> findAll(
			Ab18aTipoValidacion tipoValidacion,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Ab18aTipoValidacion>) this.tipoValidacionDao.findAll(
				tipoValidacion, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab18a10s00 table using like.
	 * 
	 * @param tipoValidacion
	 *            Ab18a10s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a10s00>
	 */
	public List<Ab18aTipoValidacion> findAllLike(
			Ab18aTipoValidacion tipoValidacion,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Ab18aTipoValidacion>) this.tipoValidacionDao.findAllLike(
				tipoValidacion, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab18a10s00 table.
	 * 
	 * @param filterAb18a10s00
	 *            Ab18a10s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Ab18aTipoValidacion filterAb18a10s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.tipoValidacionDao.removeMultiple(filterAb18a10s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab18a10s00 table.
	 * 
	 * @param filterAb18a10s00
	 *            Ab18a10s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Ab18a10s00>
	 */
	public JQGridResponseDto<Ab18aTipoValidacion> filter(
			Ab18aTipoValidacion filterAb18a10s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Ab18aTipoValidacion> listaAb18a10s00 = this.tipoValidacionDao
				.findAllLike(filterAb18a10s00, jqGridRequestDto, false);
		Long recordNum = this.tipoValidacionDao.findAllLikeCount(
				filterAb18a10s00 != null ? filterAb18a10s00
						: new Ab18aTipoValidacion(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Ab18aTipoValidacion>> reorderSelection = this.tipoValidacionDao
					.reorderSelection(filterAb18a10s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Ab18aTipoValidacion>(jqGridRequestDto,
					recordNum, listaAb18a10s00, reorderSelection);
		}
		return new JQGridResponseDto<Ab18aTipoValidacion>(jqGridRequestDto,
				recordNum, listaAb18a10s00);
	}

	/**
	 * Searches rows in the Ab18a10s00 table.
	 * 
	 * @param filterAb18a10s00
	 *            Ab18a10s00
	 * @param searchAb18a10s00
	 *            Ab18a10s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a10s00>>
	 */
	public List<TableRowDto<Ab18aTipoValidacion>> search(
			Ab18aTipoValidacion filterAb18a10s00,
			Ab18aTipoValidacion searchAb18a10s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tipoValidacionDao.search(filterAb18a10s00,
				searchAb18a10s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab18a10s00 table.
	 * 
	 * @param filterAb18a10s00
	 *            Ab18a10s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Ab18aTipoValidacion filterAb18a10s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tipoValidacionDao.reorderSelection(filterAb18a10s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab18a10s00 table.
	 * 
	 * @param filterAb18a10s00
	 *            Ab18a10s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a10s00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aTipoValidacion>> jerarquia(
			Ab18aTipoValidacion filterAb18a10s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<JerarquiaDto<Ab18aTipoValidacion>> listaAb18a10s00 = this.tipoValidacionDao
				.findAllLikeJerarquia(filterAb18a10s00, jqGridRequestDto);
		Long recordNum = this.tipoValidacionDao.findAllLikeCountJerarquia(
				filterAb18a10s00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Ab18aTipoValidacion>>(
				jqGridRequestDto, recordNum, listaAb18a10s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab18a10s00 table.
	 * 
	 * @param filterAb18a10s00
	 *            Ab18a10s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a10s00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aTipoValidacion>> jerarquiaChildren(
			Ab18aTipoValidacion filterAb18a10s00,
			JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Ab18aTipoValidacion>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Ab18aTipoValidacion>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.tipoValidacionDao.findAllChild(filterAb18a10s00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

}
